% Planner's allocation
% Version of the model with iid a and g(c) = log and 
% w' = a^alpha *S^beta


function [timeseries] = hand_fixS_planner(param)

global alpha beta b H a w pi_a Int_pi_w N_a w_max w_min b  log_a_mu mp N_w

% Parameters
omega       = param(1);
sig         = param(2);
rho         = param(3); 
S_A         = param(4);
S_B         = param(5);
log_w_sigma = param(6);
corr_wa     = param(7);
log_w_mu    = param(8);

% Grids
[log_a,Pr] = tauchen(N_a,log_a_mu,rho,sig,mp);
a = exp(log_a)';

% Control parameters
T = param(end);
It = 100; tol = 1e-4;

%% Grids and distributions

% multivariate lognormal distribution for a and w

a_min = min(a);
a_max = max(a);

log_w_min = log_w_mu-20*log_w_sigma;
log_w_max = log_w_mu+5*log_w_sigma;
log_w = linspace(log_w_min,log_w_max,N_w);
w = exp(log_w);
w_min = min(w);
w_max = max(w);


log_ar_sigma = sqrt(sig^2 / (1 - rho^2)); % Implied std. deviation
log_a_sigma = sqrt(log_ar_sigma^2);

mu = [log_a_mu log_w_mu];
Sigma = [log_a_sigma^2 corr_wa*log_w_sigma*log_a_sigma; ...
    corr_wa*log_w_sigma*log_a_sigma log_w_sigma^2];
[LA,LW] = meshgrid(log_a,log_w);
Prob = mvnpdf([LA(:) LW(:)],mu,Sigma);
[A,W] = meshgrid(a,w);
Prob = reshape(Prob,length(w),length(a));
Prob = Prob/sum(sum(Prob));

% This version has no wage shocks, collapse the grid for \varpesilon

e_min = 0;
e_max = 0;
N_e = 1;
e = linspace(e_min,e_max,N_e);
pi_e = 1;

%% Solve for planner's allocation

S_B_t = zeros(1,T);
S_A_t = zeros(1,T);
r_A_t = zeros(1,T);

w_hat = zeros(1,N_a);


for t = 1:1;
  
    pi_a = sum(Prob);
    pi_w = sum(Prob,2);

    pi_w_cond = Prob./repmat(pi_a,N_w,1);
    pi_a_cond = Prob./repmat(pi_w,1,N_a);
    pi_a_cond(isnan(pi_a_cond))=0;

    w_mat = repmat(w',1,N_a);
    Int_pi_w = cumsum(pi_w_cond);
    Int_w_pi_w  = cumsum(w_mat.*pi_w_cond);
 
    a_mat = repmat(a,N_w,1);
    Int_pi_a = cumsum(pi_a_cond')';
    Int_a_pi_a  = cumsum(a_mat.*pi_a_cond);


    Int_a_cond_a = sum(pi_a_cond.*a,2);
  
             
            % Find a cutoffs for given  S_A, S_B 
            % Planner moves to A all people at idx_a+1 and above + a fraction
            % weight_a of the people at idx_a-1
            cdf_a = cumsum(pi_a);
            
            idx_a = find(cdf_a>1-H,1);
            weight_a = (cdf_a(idx_a)-(1-H))/pi_a(idx_a);

            a_hat = (1-weight_a)*a(idx_a)+weight_a*a(idx_a-1);
            

r_A      = 0;
r_A_t(t) = r_A;
S_A_t(t) = S_A;
S_B_t(t) = S_B;

% Update distribution. Coordinates are (a,w)
w_mat = repmat(w',1,N_a,N_e);
a_mat = repmat(a,N_w,1,N_e);

e_mat = zeros(N_w,N_a,N_e);
for i = 1:N_e
    e_mat(:,:,i) = repmat(e(i),N_w,N_a);
end

wprime = (b + a_mat.^alpha.*((S_B*(a_mat<a_hat)+S_A*(a_mat>a_hat)).^beta));
avg_w = w*pi_w;
cons = avg_w; % planner equalizes consumption
welf = log(cons)+log(wprime);

avg_log_cons = sum(log(cons).*Prob,1:2);
var_log_cons = sum((log(cons)-avg_log_cons).^2.*Prob,1:2) ;

wprime_idx_a = (b + a(idx_a).^alpha.*S_A.^beta);

wprime = min(max(wprime,w_min),w_max);

[~, i_wprime] = histc(wprime,w);
i_wprime = min(i_wprime,N_w-1);
[~, i_wprime_idx_a] = histc(wprime_idx_a,w);
i_wprime_idx_a = min(i_wprime_idx_a,N_w-1);
weights = (wprime-w(i_wprime))./(w(i_wprime+1)-w(i_wprime));
weights_idx_a = (wprime_idx_a-w(i_wprime_idx_a))./(w(i_wprime_idx_a+1)-w(i_wprime_idx_a));

Probi = zeros(N_w,N_a);
for k = 1:N_e
    for j = 1:N_w
        for i = 1:N_a
            for l=1:N_a

                    Probi(i_wprime(j,i,k),l) = Probi(i_wprime(j,i,k),l)+ (1-weights(j,i,k))*Prob(j,i)*pi_e(k)*Pr(i,l);
                    Probi(i_wprime(j,i,k)+1,l) = Probi(i_wprime(j,i,k)+1,l) + weights(j,i,k)*Prob(j,i)*pi_e(k)*Pr(i,l);
               
            end
        end
    end
end

%% Calculate statistics
avg_a_B = sum(sum(Prob.*(a_mat.*((a_mat<a_hat)))))./sum(sum((Prob.*(a_mat<a_hat))));
avg_a_A = sum(sum(Prob.*(a_mat.*((a_mat>a_hat)))))./sum(sum((Prob.*(a_mat>a_hat))));

% Welfare
avg_ut = sum(sum(welf.*Prob));

pi_w = sum(Probi,2);
w_m_t = w*pi_w;

% Gini
gini = 0;
for i = 1:N_w
    for j = 1:N_w
        gini = pi_w(i)*pi_w(j)*abs(w(i)-w(j)) + gini;
    end
end
gini = gini/(2*w_m_t);

avg_w = w*pi_w;
var_w_kids = (w-avg_w).^2*pi_w ;

avg_logw = log(w)*pi_w;
var_logw_kids = (log(w)-avg_logw).^2*pi_w ;


% wage ratios
cdf_w = cumsum(pi_w);
idx = find(cdf_w>.9,1);
weight = (cdf_w(idx)-.9)/(cdf_w(idx)-cdf_w(idx-1));
w_90 = (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.1,1);
weight = (cdf_w(idx)-.1)/(cdf_w(idx)-cdf_w(idx-1));
w_10 = (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.5,1);
weight = (cdf_w(idx)-.5)/(cdf_w(idx)-cdf_w(idx-1));
w_50 = (1-weight)*w(idx)+weight*w(idx-1);

ratio_90_10_kids = w_90 / w_10;
ratio_90_50_kids = w_90 / w_50;

% Dissimilarity
pi_w = sum(Prob,2);

cdf_w = cumsum(pi_w);
idx = find(cdf_w>.8,1);

weight = (cdf_w(idx)-.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w(idx)+weight*w(idx-1);

for i = idx_a:N_a
    auxrichA(i) = 1-interp1(w,Int_pi_w(:,i)',w_80);      
end


temp_richA = auxrichA.*pi_a;
temp_richA(idx_a) = weight_a*temp_richA(idx_a) ;
richA = sum(temp_richA);
poorA = H - richA;

auxpoorB = zeros(1,N_a);
for i = 1:idx_a      
   auxpoorB(i) = interp1(w,Int_pi_w(:,i)',w_80);
end
temp_poorB = auxpoorB.*pi_a;
temp_poorB(idx_a) = (1-weight_a)*temp_poorB(idx_a) ;
poorB = sum(temp_poorB);


richB = 1 - H - poorB;
rich = richA + richB;
poor = poorA + poorB;

dissim = [abs(poorA/poor-richA/rich)+ abs(poorB/poor-richB/rich)]/2;

% Dissimilarity by ability
n_A = (a_mat>a_hat);
cdf_a = cumsum(pi_a);
idx = find(cdf_a>.8,1);
weight = (cdf_a(idx)-.8)/(cdf_a(idx)-cdf_a(idx-1));
w_80 = (1-weight)*a(idx)+weight*a(idx-1);

high_ab_A = sum(sum(Prob(:,idx:end).*n_A(:,idx:end)));
high_ab_A = high_ab_A;
low_ab_A = sum(sum(Prob.*n_A)) - high_ab_A;
high_ab_B = sum(sum(Prob(:,idx:end).*(1-n_A(:,idx:end))));
low_ab_B = 1-sum(sum(Prob.*n_A)) - high_ab_B;
high_ab = high_ab_A + high_ab_B;
low_ab = low_ab_A + low_ab_B;

dissim_ab = [abs(low_ab_A/low_ab-high_ab_A/high_ab)+ abs(low_ab_B/low_ab-high_ab_B/high_ab)]/2;

% upward mobility
% find 25th and 75th percentile 
pi_w = sum(Prob,2);
cdf_w = cumsum(pi_w);

pi_w_kids = sum(Probi,2);
cdf_w_kids = cumsum(pi_w_kids);

idx_25 = find(cdf_w>.25,1);
weight = (cdf_w(idx_25)-.25)/(cdf_w(idx_25)-cdf_w(idx_25-1));
w_25 = (1-weight)*w(idx_25)+weight*w(idx_25-1);

idx_75 = find(cdf_w>.75,1);
weight = (cdf_w(idx_75)-.75)/(cdf_w(idx_75)-cdf_w(idx_75-1));
w_75 = (1-weight)*w(idx_75)+weight*w(idx_75-1);

% find probability of staying below 25th percentile for each (ability,wage) pair

 Prob_kids_25 = zeros(N_w,N_a);

    for j = 1:idx_25
        for i = 1:N_a
            for l=1:N_a
            if i==idx_a
                    % Those at idx_a that go to B:
                    Prob_kids_25(i_wprime(j,i,k),l) = Prob_kids_25(i_wprime(j,i,k),l)+ (1-weight_a)*(1-weights(j,i,k))*Prob(j,i)*pi_e(k)*Pr(i,l);
                    Prob_kids_25(i_wprime(j,i,k)+1,l) = Prob_kids_25(i_wprime(j,i,k)+1,l) + (1-weight_a)*weights(j,i,k)*Prob(j,i)*pi_e(k)*Pr(i,l);
                    
                    % Those at idx_a that go to A:
                    Prob_kids_25(i_wprime_idx_a,l) = Prob_kids_25(i_wprime_idx_a,l)+ weight_a*(1-weights_idx_a)*Prob(j,i)*pi_e(k)*Pr(i,l);
                    Prob_kids_25(i_wprime_idx_a+1,l) = Prob_kids_25(i_wprime_idx_a+1,l) + weight_a*weights_idx_a*Prob(j,i)*pi_e(k)*Pr(i,l);
             else
                    Prob_kids_25(i_wprime(j,i),l)   = Prob_kids_25(i_wprime(j,i),l)+ (1-weights(j,i))*Prob(j,i)*Pr(i,l);
                    Prob_kids_25(i_wprime(j,i)+1,l) = Prob_kids_25(i_wprime(j,i)+1,l) + weights(j,i)*Prob(j,i)*Pr(i,l);
            end
            end
        end
    end


mobility_up = sum(Prob_kids_25,2)/cdf_w(idx_25);
cdf_up = cumsum(mobility_up);


idx_25_kids = find(cdf_w_kids>.25,1);
weight = (cdf_w_kids(idx_25_kids)-.25)/(cdf_w_kids(idx_25_kids)-cdf_w_kids(idx_25_kids-1));
w_25_kids = (1-weight)*w(idx_25_kids)+weight*w(idx_25_kids-1);

idx_75_kids = find(cdf_w_kids>.75,1);
weight = (cdf_w_kids(idx_75_kids)-.75)/(cdf_w_kids(idx_75_kids)-cdf_w_kids(idx_75_kids-1));
w_75_kids = (1-weight)*w(idx_75_kids)+weight*w(idx_75_kids-1);

Q1toQ1 = interp1(w,cdf_up,w_25_kids);
Q1toQ4 = 1-interp1(w,cdf_up,w_75_kids);


 Prob_kids_75 = zeros(N_w,N_a);

    for j = idx_75:N_w
        for i = 1:N_a
            for l=1:N_a
                if i==idx_a
                    % Those at idx_a that go to B:
                    Prob_kids_75(i_wprime(j,i,k),l) = Prob_kids_75(i_wprime(j,i,k),l)+ (1-weight_a)*(1-weights(j,i,k))*Prob(j,i)*pi_e(k)*Pr(i,l);
                    Prob_kids_75(i_wprime(j,i,k)+1,l) = Prob_kids_75(i_wprime(j,i,k)+1,l) + (1-weight_a)*weights(j,i,k)*Prob(j,i)*pi_e(k)*Pr(i,l);
                    
                    % Those at idx_a that go to A:
                    Prob_kids_75(i_wprime_idx_a,l) = Prob_kids_75(i_wprime_idx_a,l)+ weight_a*(1-weights_idx_a)*Prob(j,i)*pi_e(k)*Pr(i,l);
                    Prob_kids_75(i_wprime_idx_a+1,l) = Prob_kids_75(i_wprime_idx_a+1,l) + weight_a*weights_idx_a*Prob(j,i)*pi_e(k)*Pr(i,l);
                else
                
                    Prob_kids_75(i_wprime(j,i),l)   = Prob_kids_75(i_wprime(j,i),l)+ (1-weights(j,i))*Prob(j,i)*Pr(i,l);
                    Prob_kids_75(i_wprime(j,i)+1,l) = Prob_kids_75(i_wprime(j,i)+1,l) + weights(j,i)*Prob(j,i)*Pr(i,l);
                end
            end
        end
    end
mobility = sum(Prob_kids_75,2)/(1-cdf_w(idx_75-1));
cdf_down = cumsum(mobility);
Q4toQ4 = 1-interp1(w,cdf_down,w_75_kids);

% rank-rank
N_bp1 = 100;
q = linspace(0,1,N_bp1);
w_q = zeros(1,N_bp1);
w_q(1) = w_min;
w_q(N_bp1)= w_max+1e-5;
for i = 1:(N_bp1-2)
  find_q_w = @(x)interp1(w,cdf_w,x,[],'extrap')-q(i+1);
  w_q(i+1) = fzero(find_q_w,(w_max+w_min)/2);
end

w_qk = zeros(1,N_bp1);
w_qk(1) = w_min;
w_qk(N_bp1)= w_max+1e-5;
for i = 1:(N_bp1-2)
  find_q_w = @(x)interp1(w,cdf_w_kids,x,[],'extrap')-q(i+1);
  w_qk(i+1) = fzero(find_q_w,(w_max+w_min)/2);
end

parents_rank = zeros(N_w,N_a);
for m = 1:(N_bp1-1)
    for i = 1:N_w
        if w_q(m)<=w(i) && w_q(m+1)>w(i)
            parents_rank(i,:) = m;
        end
    end
end

[~, kids_rank] = histc(wprime,w_qk);
[~, kids_rank_idx_a] = histc(wprime_idx_a,w_qk);
kids_rank(:,idx_a) = (1-weight_a)*kids_rank(:,idx_a) + weight_a*kids_rank_idx_a;

mu_prank = sum(sum(parents_rank.*Prob));
mu_krank = sum(sum(kids_rank.*Prob));

prank_std = sum(sum((parents_rank-mu_prank).^2.*Prob));
prank_std = sqrt(prank_std(:));
krank_std = sum(sum((kids_rank-mu_krank).^2.*Prob));
krank_std = sqrt(krank_std(:));

rank_cov = sum(sum((parents_rank - mu_prank).*(kids_rank-mu_krank).*Prob));

rank_corr = rank_cov/(prank_std*krank_std);

%% Check convergence to steady state (for dynamic case)

if max(abs(Probi-Prob))<1e-8
    break
end

Prob = Probi;

timeseries{t,1} = dissim;
timeseries{t,2} = gini;
timeseries{t,3} = ratio_90_10_kids;
timeseries{t,4} = Q1toQ1;
timeseries{t,5} = Q1toQ4;
timeseries{t,6} = Q4toQ4;
timeseries{t,7} = rank_corr;
timeseries{t,8} = ratio_90_50_kids;
timeseries{t,9} = var_w_kids;
timeseries{t,12} = avg_a_A;
timeseries{t,13} = avg_a_B;
timeseries{t,22} = avg_ut;
timeseries{t,25} = var_log_cons;
timeseries{t,26} = var_logw_kids;
timeseries{t,27} = dissim_ab;





end





end

