% Static model 
% Spillover exogenous
% Version of the model with iid a and g(c) = log and 
% w' = b+a^alpha *S^beta


function [timeseries] = hand_fixS(param)

global alpha beta b H a w pi_a Int_pi_w N_a w_max w_min b  log_a_mu log_a_sigma mp N_w

% Parameters
omega       = param(1);
sig         = param(2);
rho         = param(3); 
S_A         = param(4);
S_B         = param(5);
log_w_sigma = param(6);
corr_wa     = param(7);
log_w_mu    = param(8);

% Grids
[log_a,Pr] = tauchen(N_a,log_a_mu,rho,sig,mp);
a = exp(log_a)';

% Control parameters
T = param(9);
It = 100; tol = 1e-4;

%% Grids and distributions

% multivariate lognormal distribution for a and w

a_min = min(a);
a_max = max(a);

log_w_min = log_w_mu-20*log_w_sigma;
log_w_max = log_w_mu+5*log_w_sigma;
log_w = linspace(log_w_min,log_w_max,N_w);
w = exp(log_w);
w_min = min(w);
w_max = max(w);

log_ar_sigma = sqrt(sig^2 / (1 - rho^2)); % Implied std. deviation
log_a_sigma = sqrt(log_ar_sigma^2);

mu = [log_a_mu log_w_mu];
Sigma = [log_a_sigma^2 corr_wa*log_w_sigma*log_a_sigma; ...
    corr_wa*log_w_sigma*log_a_sigma log_w_sigma^2];
[LA,LW] = meshgrid(log_a,log_w);
Prob = mvnpdf([LA(:) LW(:)],mu,Sigma);
[A,W] = meshgrid(a,w);
Prob = reshape(Prob,length(w),length(a));
Prob = Prob/sum(sum(Prob));


% This version has no wage shocks, collapse the grid for \varpesilon

e_min = 0;
e_max = 0;
N_e = 1;
e = linspace(e_min,e_max,N_e);
pi_e = 1;


%% Solve for the equilibrium

S_B_t = zeros(1,T);
S_A_t = zeros(1,T);
r_A_t = zeros(1,T);

w_hat = zeros(1,N_a);


for t = 1:T

    pi_a = sum(Prob);
    pi_w = sum(Prob,2);

    pi_w_cond = Prob./repmat(pi_a,N_w,1);
    pi_a_cond = Prob./repmat(pi_w,1,N_a);
    pi_a_cond(isnan(pi_a_cond))=0;

    w_mat = repmat(w',1,N_a);
    Int_pi_w = cumsum(pi_w_cond);
    Int_w_pi_w  = cumsum(w_mat.*pi_w_cond);
 
    a_mat = repmat(a,N_w,1);
    Int_pi_a = cumsum(pi_a_cond')';
    Int_a_pi_a  = cumsum(a_mat.*pi_a_cond);


    Int_a_cond_a = sum(pi_a_cond.*a,2);

            % Solve for equilibrium rent for given S_A, S_B
            if find_rA_redistr(0,S_B,S_A,pi_w)<=0 % First evaluate at zero rent
                r_A = 0;
            else
                r_A = fzero(@find_rA_redistr,.4,[],S_B,S_A,pi_w);
            end
            
            % redistribute rental profits to top 20th percentile of income distribution
            % in proportion to their income

            cdf_w = cumsum(pi_w);
            idx = find(cdf_w>0.8,1);
            weight = (cdf_w(idx)-0.8)/(cdf_w(idx)-cdf_w(idx-1));
            w_80 = (1-weight)*w(idx)+weight*w(idx-1);
            
            ll_w = sum(w(idx:end)*pi_w(idx:end)); % weight proportional to income
            wt_ll = w.*(w>=w_80)./ll_w;

            w_prof = w+  wt_ll*r_A*H;

            % Find w cutoffs for given r_A, S_A, S_B          
            if S_A<=S_B
               w_hat = w_max*ones(1,N_a);
            else
               w_hat = (( b./(a.^alpha)+S_A^beta)./(S_A^beta-S_B^beta)).* r_A;
            end
            
            w_hat = min(max(w_hat,min(w_prof)),max(w_prof));

            a_hat = (r_A*b./(w_prof.*(S_A^beta-S_B^beta)-r_A*S_A^beta)).^(1/alpha);
            a_hat(a_hat<0) = a_max;

            a_hat = min(max(a_hat,a_min),a_max);
    
            
r_A_t(t) = r_A;
S_A_t(t) = S_A;
S_B_t(t) = S_B;

% Update distribution. Coordinates are (a,w)
w_mat = repmat(w_prof',1,N_a,N_e);
a_mat = repmat(a,N_w,1,N_e);
w_hat_mat = repmat(w_hat,N_w,1,N_e);

e_mat = zeros(N_w,N_a,N_e);
for i = 1:N_e
    e_mat(:,:,i) = repmat(e(i),N_w,N_a);
end

wprime = (b + a_mat.^alpha.*((S_B*(w_mat<w_hat_mat)+S_A*(w_mat>=w_hat_mat)).^beta));
wprime = min(max(wprime,w_min),w_max);

cons = w_mat-(0*(w_mat<w_hat_mat)+r_A*(w_mat>=w_hat_mat));
welf = log(cons)+log(wprime);
avg_log_cons = sum(log(cons).*Prob,1:2);
var_log_cons = sum((log(cons)-avg_log_cons).^2.*Prob,1:2) ;


[~, i_wprime] = histc(wprime,w);
i_wprime = min(i_wprime,N_w-1);
weights = (wprime-w(i_wprime))./(w(i_wprime+1)-w(i_wprime));

Probi = zeros(N_w,N_a);
for k = 1:N_e
    for j = 1:N_w
        for i = 1:N_a
            for l=1:N_a
            Probi(i_wprime(j,i,k),l) = Probi(i_wprime(j,i,k),l)+ (1-weights(j,i,k))*Prob(j,i)*pi_e(k)*Pr(i,l);
            Probi(i_wprime(j,i,k)+1,l) = Probi(i_wprime(j,i,k)+1,l) + weights(j,i,k)*Prob(j,i)*pi_e(k)*Pr(i,l);
            end
        end
    end
end

%% Calculate statistics

% Average ability by neighborhood
avg_a_B = sum(sum(Prob.*(a_mat.*((w_mat<w_hat_mat)))))./sum(sum((Prob.*(w_mat<w_hat_mat))));
avg_a_A = sum(sum(Prob.*(a_mat.*((w_mat>w_hat_mat)))))./sum(sum((Prob.*(w_mat>w_hat_mat))));

% Gini kids
pi_w = sum(Probi,2);
w_m_t = w*pi_w;

% Gini
gini = 0;
for i = 1:N_w
    for j = 1:N_w
        gini = pi_w(i)*pi_w(j)*abs(w(i)-w(j)) + gini;
    end
end
gini = gini/(2*w_m_t);

pi_w = sum(Probi,2);
w_m_t = w*pi_w;

avg_w = w*pi_w;
var_w_kids = (w-avg_w).^2*pi_w ;

avg_logw = log(w)*pi_w;
var_logw_kids = (log(w)-avg_logw).^2*pi_w ;


% 90-10 ratio
pi_w = sum(Probi,2);
cdf_w = cumsum(pi_w);
idx = find(cdf_w>.9,1);
weight = (cdf_w(idx)-.9)/(cdf_w(idx)-cdf_w(idx-1));
w_90_k= (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.1,1);
weight = (cdf_w(idx)-.1)/(cdf_w(idx)-cdf_w(idx-1));
w_10 = (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.5,1);
weight = (cdf_w(idx)-.5)/(cdf_w(idx)-cdf_w(idx-1));
w_50_k = (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.2,1);
weight = (cdf_w(idx)-.2)/(cdf_w(idx)-cdf_w(idx-1));
w_20 = (1-weight)*w(idx)+weight*w(idx-1);

idx = find(cdf_w>.8,1);
weight = (cdf_w(idx)-.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w(idx)+weight*w(idx-1);

ratio_90_10_k = w_90_k / w_10;
ratio_90_50_k = w_90_k / w_50_k;
ratio_80_20_k = w_80 / w_20;

% theil index
theil = sum(pi_w'.*w./avg_w.*log(w./avg_w));


%%%% Parents %%%%%
% Gini parents
pi_w = sum(Prob,2);
w_m_t = w_prof*pi_w;
gini_par = 0;
for i = 1:N_w
    for j = 1:N_w
        gini_par = pi_w(i)*pi_w(j)*abs(w_prof(i)-w_prof(j)) + gini;
    end
end
gini_par = gini_par/(2*w_m_t);

avg_logw = log(w_prof)*pi_w;
var_logw = (log(w_prof)-avg_logw).^2*pi_w ;

% Welfare
avg_ut = sum(sum(welf.*Prob));

% Wage ratios
pi_w = sum(Prob,2);
cdf_w = cumsum(pi_w);
idx = find(cdf_w>.9,1);
weight = (cdf_w(idx)-.9)/(cdf_w(idx)-cdf_w(idx-1));
w_90 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);

idx = find(cdf_w>.1,1);
weight = (cdf_w(idx)-.1)/(cdf_w(idx)-cdf_w(idx-1));
w_10 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);

idx = find(cdf_w>.5,1);
weight = (cdf_w(idx)-.5)/(cdf_w(idx)-cdf_w(idx-1));
w_50 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);

idx = find(cdf_w>.2,1);
weight = (cdf_w(idx)-.2)/(cdf_w(idx)-cdf_w(idx-1));
w_20 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);

idx = find(cdf_w>.8,1);
weight = (cdf_w(idx)-.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);

ratio_90_10 = w_90 / w_10;
ratio_90_50 = w_90 / w_50;
ratio_80_20 = w_80 / w_20;

% Dissimilarity
pi_w = sum(Prob,2);

cdf_w = cumsum(pi_w);
idx = find(cdf_w>.8,1);

weight = (cdf_w(idx)-.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w_prof(idx)+weight*w_prof(idx-1);


for i = 1:N_a
    auxrichA(i) = interp1(w_prof,Int_pi_w(:,i)',max(w_hat(i),w_80));      
    auxpoorB(i) = interp1(w_prof,Int_pi_w(:,i)',min(w_hat(i),w_80));
end
richA = (1-auxrichA)*pi_a';
poorA = H - richA;
poorB = auxpoorB*pi_a';
richB = 1 - H - poorB;
rich = richA + richB;
poor = poorA + poorB;

dissim = [abs(poorA/poor-richA/rich)+ abs(poorB/poor-richB/rich)]/2;

% Dissimilarity by ability
n_A = (w_mat>w_hat_mat);

cdf_a = cumsum(pi_a);
idx = find(cdf_a>.8,1);
weight = (cdf_a(idx)-.8)/(cdf_a(idx)-cdf_a(idx-1));
w_80 = (1-weight)*a(idx)+weight*a(idx-1);

high_ab_A = sum(sum(Prob(:,idx:end).*n_A(:,idx:end)));
low_ab_A = sum(sum(Prob.*n_A)) - high_ab_A;
high_ab_B = sum(sum(Prob(:,idx:end).*(1-n_A(:,idx:end))));
low_ab_B = 1-sum(sum(Prob.*n_A)) - high_ab_B;
high_ab = high_ab_A + high_ab_B;
low_ab = low_ab_A + low_ab_B;

dissim_ab = [abs(low_ab_A/low_ab-high_ab_A/high_ab)+ abs(low_ab_B/low_ab-high_ab_B/high_ab)]/2;

% Upward mobility

% find 25th and 75th percentile 

pi_w = sum(Prob,2);
cdf_w = cumsum(pi_w);

pi_w_kids = sum(Probi,2);
cdf_w_kids = cumsum(pi_w_kids);

idx_25 = find(cdf_w>.25,1);
weight = (cdf_w(idx_25)-.25)/(cdf_w(idx_25)-cdf_w(idx_25-1));
w_25 = (1-weight)*w(idx_25)+weight*w(idx_25-1);

idx_75 = find(cdf_w>.75,1);
weight = (cdf_w(idx_75)-.75)/(cdf_w(idx_75)-cdf_w(idx_75-1));
w_75 = (1-weight)*w(idx_75)+weight*w(idx_75-1);

% find probability of staying below 25th percentile for each (ability,wage) pair

 Prob_kids_25 = zeros(N_w,N_a);

    for j = 1:idx_25
        for i = 1:N_a
            for l=1:N_a
            Prob_kids_25(i_wprime(j,i),l)   = Prob_kids_25(i_wprime(j,i),l)+ (1-weights(j,i))*Prob(j,i)*Pr(i,l);
            Prob_kids_25(i_wprime(j,i)+1,l) = Prob_kids_25(i_wprime(j,i)+1,l) + weights(j,i)*Prob(j,i)*Pr(i,l);
            end
        end
    end


mobility_up = sum(Prob_kids_25,2)/cdf_w(idx_25);
cdf_up = cumsum(mobility_up);

idx_25_kids = find(cdf_w_kids>.25,1);
weight = (cdf_w_kids(idx_25_kids)-.25)/(cdf_w_kids(idx_25_kids)-cdf_w_kids(idx_25_kids-1));
w_25_kids = (1-weight)*w(idx_25_kids)+weight*w(idx_25_kids-1);

idx_75_kids = find(cdf_w_kids>.75,1);
weight = (cdf_w_kids(idx_75_kids)-.75)/(cdf_w_kids(idx_75_kids)-cdf_w_kids(idx_75_kids-1));
w_75_kids = (1-weight)*w(idx_75_kids)+weight*w(idx_75_kids-1);

Q1toQ1 = interp1(w,cdf_up,w_25_kids);
Q1toQ4 = 1-interp1(w,cdf_up,w_75_kids);

 Prob_kids_75 = zeros(N_w,N_a);

    for j = idx_75:N_w
        for i = 1:N_a
            for l=1:N_a
            Prob_kids_75(i_wprime(j,i),l)   = Prob_kids_75(i_wprime(j,i),l)+ (1-weights(j,i))*Prob(j,i)*Pr(i,l);
            Prob_kids_75(i_wprime(j,i)+1,l) = Prob_kids_75(i_wprime(j,i)+1,l) + weights(j,i)*Prob(j,i)*Pr(i,l);
            end
        end
    end
mobility = sum(Prob_kids_75,2)/(1-cdf_w(idx_75-1));
cdf_down = cumsum(mobility);
Q4toQ4 = 1-interp1(w,cdf_down,w_75_kids);

% rank-rank
N_bp1 = 100;
q = linspace(0,1,N_bp1);
w_q = zeros(1,N_bp1);
w_q(1) = w_min;
w_q(N_bp1)= max(w_prof)+1e-5;
for i = 1:(N_bp1-2)
  find_q_w = @(x)interp1(w_prof,cdf_w,x,[],'extrap')-q(i+1);
  w_q(i+1) = fzero(find_q_w,(max(w_prof)+w_min)/2);
end

w_qk = zeros(1,N_bp1);
w_qk(1) = w_min;
w_qk(N_bp1)= w_max+1e-5;
for i = 1:(N_bp1-2)
  find_q_w = @(x)interp1(w,cdf_w_kids,x,[],'extrap')-q(i+1);
  w_qk(i+1) = fzero(find_q_w,(w_max+w_min)/2);
end

parents_rank = zeros(N_w,N_a);
for m = 1:(N_bp1-1)
    for i = 1:N_w
        if w_q(m)<=w_prof(i) && w_q(m+1)>w_prof(i)
            parents_rank(i,:) = m;
        end
    end
end

[~, kids_rank] = histc(wprime,w_qk);

mu_prank = sum(sum(parents_rank.*Prob));
mu_krank = sum(sum(kids_rank.*Prob));

prank_std = sum(sum((parents_rank-mu_prank).^2.*Prob));
prank_std = sqrt(prank_std(:));
krank_std = sum(sum((kids_rank-mu_krank).^2.*Prob));
krank_std = sqrt(krank_std(:));

rank_cov = sum(sum((parents_rank - mu_prank).*(kids_rank-mu_krank).*Prob));

rank_corr = rank_cov/(prank_std*krank_std);

% Average wage and ability
avg_a = pi_a*a';
avg_w = w*pi_w;
var_w = (w-avg_w).^2*pi_w ;

%% Check convergence to steady state (for dynamic case)

if max(abs(Probi-Prob))<1e-8
    break
end

Prob = Probi;

timeseries{t,1} = dissim;
timeseries{t,2} = gini;
timeseries{t,3} = ratio_90_10;
timeseries{t,4} = Q1toQ1;
timeseries{t,5} = Q1toQ4;
timeseries{t,6} = Q4toQ4;
timeseries{t,7} = rank_corr;
timeseries{t,8} = gini_par;
timeseries{t,9} = S_A;
timeseries{t,10} = S_B;
timeseries{t,11} = r_A;
timeseries{t,12} = avg_a_A;
timeseries{t,13} = avg_a_B;
timeseries{t,14} = var_w;
timeseries{t,15} = var_w_kids;
timeseries{t,16} = ratio_90_50;
timeseries{t,17} = ratio_80_20;
timeseries{t,18} = theil;
timeseries{t,19} = var_logw;
timeseries{t,20} = avg_logw;
timeseries{t,21} = ratio_90_50_k;
timeseries{t,22} = avg_ut;
timeseries{t,23} = w_90_k;
timeseries{t,24} = w_50_k;
timeseries{t,25} = var_log_cons;
timeseries{t,26} = var_logw_kids;
timeseries{t,27} = dissim_ab;




end



end

