function F = find_rA_redistr_tax(r_A,S_B,S_A,Prob)   

global H a w pi_a N_w N_a w_max b alpha beta p_elig tr_rate

%% Redistribute rental profits to top 20th percentile of income distribution
% in proportion to their income
pi_w = sum(Prob,2);
cdf_w = cumsum(pi_w);
idx = find(cdf_w>.8,1);
weight = (cdf_w(idx)-.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w(idx)+weight*w(idx-1);     

ll_w = sum(w(idx:end)*pi_w(idx:end)); % weight proportional to income
wt_ll = w.*(w>=w_80)./ll_w;

w_prof = w+  wt_ll*r_A*H ;

%% Apply tax and transfers
avg_wage = w_prof*pi_w;
tr = tr_rate*avg_wage;
idx_pol = find(cdf_w>p_elig,1);
tr_cost = tr*(cdf_w(idx_pol));

tax_base = w_prof(idx_pol+1:end)*pi_w(idx_pol+1:end);
tax = tr_cost/tax_base;

w2=w_prof;
w2(1:idx_pol)= w_prof(1:idx_pol)+tr;
w2(idx_pol+1:end) = w_prof(idx_pol+1:end)*(1-tax);

[w2_sort idx_sort] = sort(w2);
pi_w_sort = pi_w(idx_sort);

for idx_a=1:N_a
    temp = Prob(:,idx_a);
    Prob_sort(:,idx_a) = temp(idx_sort);
end

pi_w_cond_sort = Prob_sort./repmat(pi_a,N_w,1);
w2_sort_mat = repmat(w2_sort',1,N_a);
Int_pi_w_sort = cumsum(pi_w_cond_sort);

%% find w cutoffs for given r_A, S_A, S_B
if S_A<=S_B
   w_hat = w_max*ones(1,length(a));
else
   w_hat = (( b./(a.^alpha)+S_A^beta)./(S_A^beta-S_B^beta)).* r_A;
end

w_hat = min(max(w_hat,min(w2_sort)),max(w2_sort));


%% compute housing demand in neighborhood A

zz = zeros(1,N_a);
for i = 1:N_a
    zz(i) = 1-interp1(w2_sort,Int_pi_w_sort(:,i)',w_hat(i));
end

H_dem = zz*pi_a';

F = H_dem - H;