function F = find_rA_base_eta_redistr(r_A,S_B,S_A,eta,pi_w)   

global  H a w pi_a Int_pi_w N_a w_max w_min b alpha beta

%% redistribute rental profits to top 20th percentile of income distribution
% in proportion to their income
cdf_w = cumsum(pi_w);
idx = find(cdf_w>0.8,1);
weight = (cdf_w(idx)-0.8)/(cdf_w(idx)-cdf_w(idx-1));
w_80 = (1-weight)*w(idx)+weight*w(idx-1);     

ll_w = sum(w(idx:end)*pi_w(idx:end)); % weight proportional to income
wt_ll = w.*(w>=w_80)./ll_w;

w_prof = w+  wt_ll*r_A*H;

%% find w cutoffs for given r_A, S_A, S_B

if S_A<=S_B
   w_hat = w_max*ones(1,length(a));
else
   w_hat = (( b./(eta*a.^alpha)+S_A^beta)./(S_A^beta-S_B^beta)).* r_A;
end

w_hat = min(max(w_hat,w_min),max(w_prof));


%% compute housing demand in neighborhood A

zz = zeros(1,N_a);
for i = 1:N_a
    zz(i) = 1-interp1(w_prof,Int_pi_w(:,i)',w_hat(i));
end

H_dem = zz*pi_a';

F = H_dem - H;