% Baseline model 
% Spillover exogenous
% Version of the model with iid a and g(c) = log and 
% w' = b+a^alpha *S^beta


function [excess_demand] = excess_demand(param,r_A)

global alpha beta b H a w pi_a Int_pi_w N_a w_max w_min b  log_a_mu log_a_sigma mp N_w

% Parameters
%H           = param(1);
%b           = param(2);
%beta        = param(3);
%alpha       = param(4);
omega       = param(1);
sig         = param(2);
rho         = param(3); 
S_A         = param(4);
S_B         = param(5);
log_w_sigma = param(6);
corr_wa     = param(7);
log_w_mu    = param(8);

% Grids
[log_a,Pr] = tauchen(N_a,log_a_mu,rho,sig,mp);
a = exp(log_a)';

N_e = 10;
log_e_sigma =.65;
log_e_mu = .41;

% Control parameters
T = param(9);
It = 100; tol = 1e-4;

%% Grids and distributions

% let's start with a multivariate lognormal distribution for a and w

a_min = min(a);
a_max = max(a);

log_w_min = log_w_mu-20*log_w_sigma;
log_w_max = log_w_mu+5*log_w_sigma;
log_w = linspace(log_w_min,log_w_max,N_w);
w = exp(log_w);
w_min = min(w);
w_max = max(w);

log_ar_sigma = sqrt(sig^2 / (1 - rho^2)); % Implied std. deviation
log_a_sigma = sqrt(log_ar_sigma^2);

mu = [log_a_mu log_w_mu];
Sigma = [log_a_sigma^2 corr_wa*log_w_sigma*log_a_sigma; ...
    corr_wa*log_w_sigma*log_a_sigma log_w_sigma^2];
[LA,LW] = meshgrid(log_a,log_w);
Prob = mvnpdf([LA(:) LW(:)],mu,Sigma);
[A,W] = meshgrid(a,w);
Prob = reshape(Prob,length(w),length(a));
Prob = Prob/sum(sum(Prob));

% figure(1)
% surf(a,w,Prob)

% we now define the pdf of the noise \varpesilon

e_min = exp(log_e_mu-3*log_e_sigma);
e_max = exp(log_e_mu+3*log_e_sigma);
e_min = 0;
e_max = 0;
N_e = 1;
e = linspace(e_min,e_max,N_e);
pi_e = pdf('logn',e,log_e_mu,log_e_sigma);
pi_e = pi_e/sum(pi_e);
pi_e = 1;

% figure(2)
% plot(e,pi_e,'LineWidth',2);
% xlabel('\epsilon')
% set(gca,'FontSize',16)

%% Dynamics

w_m_t = zeros(1,T);
w_v_t = zeros(1,T);
S_B_t = zeros(1,T);
S_A_t = zeros(1,T);
r_A_t = zeros(1,T);

w_hat = zeros(1,N_a);

xx_A = zeros(1,N_a);
zz_A = zeros(1,N_a);
xx_B = zeros(1,N_a);
zz_B = zeros(1,N_a);

    pi_a = sum(Prob);
    pi_w = sum(Prob,2);

    pi_w_cond = Prob./repmat(pi_a,N_w,1);
    pi_a_cond = Prob./repmat(pi_w,1,N_a);
    pi_a_cond(isnan(pi_a_cond))=0;

    w_mat = repmat(w',1,N_a);
    Int_pi_w = cumsum(pi_w_cond);
    Int_w_pi_w  = cumsum(w_mat.*pi_w_cond);
 
    a_mat = repmat(a,N_w,1);
    Int_pi_a = cumsum(pi_a_cond')';
    Int_a_pi_a  = cumsum(a_mat.*pi_a_cond);


    Int_a_cond_a = sum(pi_a_cond.*a,2);


    % excess demand
    excess_demand = find_rA_redistr(r_A,S_B,S_A,pi_w);
 